#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;

vector <int> graf[300005];
int interval[600005];
int lastr[600005];
int lastl[600005];

int dist[3005];

const int INF = 1000000000;

int l[300005];
int r[300005];

void bfs(int root, int n){
    for(int i=1; i<=n; i++){
        dist[i] = INF;
    }
    queue <int> q;
    q.push(root);
    dist[root] = 0;
    while(!q.empty()){
        int v = q.front();
        q.pop();
        for(auto c : graf[v]){
            if(dist[c] > dist[v]+1){
                dist[c] = dist[v]+1;
                q.push(c);
            }
        }
    }
}

int main(){
    ios_base::sync_with_stdio(false), cin.tie(0);
    cout.precision(10);
    cout << fixed;

    int n, q;
    cin >> n >> q;
    for(int i=1; i<=2*n; i++){
        cin >> interval[i];
        lastl[i] = lastl[i-1];
        if(l[interval[i]]){
            r[interval[i]] = i;
            lastl[i] = max(lastl[i], l[i]);
        }
        else{
            l[interval[i]] = i;
        }
    }
    for(int i=1; i<=n; i++){
        for(int j=1; j<=n; j++){
            if(i == j) continue;
            if(l[i] <= l[j] && r[j] <= r[i]){
                graf[i].push_back(j);
                graf[j].push_back(i);
            }
        }
    }
    while(q--){
        int a, b;
        cin >> a >> b;
        bfs(a, n);
        if(dist[b] == INF) cout << "-1\n";
        else cout << dist[b] << "\n";
    }
    return 0;
}